#! /bin/bash

start()
{
	if [ -f ./Config.ini ]
		then
			control=`cat Config.ini | grep Control`
			maxport=`cat Config.ini | grep MaxPort`		
			minport=`cat Config.ini | grep MinPort`
			control=${control#*=}
			maxport=${maxport#*=}
			minport=${minport#*=}		
			echo
			echo ================================================== 
			echo "1. Control Port Setting (Control Port $control)"
			echo "2. Port Range Setting (From $minport To $maxport)"
			echo "3. Exit"
			echo ==================================================
			echo
			setting

	else
		echo
		echo ==================================================	
		echo "1. Control Port Setting (Control Port 42000)"
		echo "2. Port Range Setting (Default)"
		echo "3. Exit"
		echo ==================================================
		echo
		setting	
	fi
}

setting()
{
	echo -n "Pleaese choose menu you want to do : "
	read setup
	case $setup in
		1)
			echo -n "Input Control Port number for IperfDaemon : " 
			read control
			written
			echo "Control Port Setting is completed!"
			clear	
			start;;
		
		2)
			echo "Enter the Port Range Num you want to use for IperfDaemon (from...to...)"
			echo -n "Start Port Num : "
			read minport
			echo -n "End Port Num : "
			read maxport
			written			
			echo "Port Range Setting is completed!"
			clear
			start;;

		3)
			clear			
			exit;;
		*)
			echo "Incorrect menu! Please choose again."
			clear			
			start;;
	esac
}

written()
{
	
	echo "[Config]" > Config.ini
	echo "Control=$control" >> Config.ini
	echo "MaxPort=$maxport" >> Config.ini
	echo "MinPort=$minport"	>> Config.ini
}

start
